﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    /// <summary>
    /// This control provides a visual demonstration of how to use the DetectedSignalList class which
    /// is exposed by most device objects.
    /// </summary>
    public partial class DetectedSignals : UserControl
    {

        private DetectedSignalList DetectedList;       // List of detected signals

        public DetectedSignals()
        {
            InitializeComponent();
            lst_DetectedSignals.Items.Clear();
        }

        /// <summary>
        /// This assigns the list which this control should interact with
        /// </summary>
        public void SetList(DetectedSignalList List)
        {
            this.DetectedList = List;
            if (DetectedList == null) return;

            chk_Enabled.Checked = List.Enable;
            timer_Update.Enabled = true;
        }



        private void chk_Enabled_CheckedChanged(object sender, EventArgs e)
        {
            if (DetectedList == null) return;
            DetectedList.Enable = chk_Enabled.Checked;
        }

        private void timer_Update_Tick(object sender, EventArgs e)
        {
            /* Here we use the detected signal list as a buffer from which we pull any 
             * detected signals and put them into the listbox.
             * */
            const int MaximumCount = 50;
            try
            {
                if (DetectedList == null) return;
                if (DetectedList.Count <= 0) return;
                

                IDetectedSignal[] Items = DetectedList.Extract();

                for (int i = 0; i < Items.Length; i++)
                {
                    System.Diagnostics.Debug.Print("Extracted " + Items[i].ToString());


                    // locate the best place in the list to insert this item
                    int BestIndex = -1;
                    for (int j = 0; j < lst_DetectedSignals.Items.Count; j++)
                    {
                        IDetectedSignal S = lst_DetectedSignals.Items[j] as IDetectedSignal;
                        if (Items[i].Time.DeviceTime > S.Time.DeviceTime)
                        {
                            BestIndex = j - 1;
                            break;
                        }
                    }
                    if (BestIndex < 0) BestIndex = 0;
                    lst_DetectedSignals.Items.Insert(BestIndex, Items[i]);
                }
                    
                // now ensure the list doesn't grow to an unmanagable size
                int Excess =lst_DetectedSignals.Items.Count - MaximumCount;
                if (Excess <= 0) return;

                for (int i = 0; i < Excess; i++)
                    lst_DetectedSignals.Items.RemoveAt(lst_DetectedSignals.Items.Count - 1);

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btn_Clear_Click(object sender, EventArgs e)
        {
            try
            {
                if (DetectedList == null) return;

                DetectedList.Clear();
                lst_DetectedSignals.Items.Clear();

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }


    }
}
